<?php $__env->startSection('title', __('Augmented Reality')); ?>

<?php $__env->startSection('content'); ?>
  <?php
    $cameraParametersUrl = asset('storage/camera/camera_para.dat');
  ?>
   
  <a-scene 
    embedded 
    arjs='debugUIEnabled:false; sourceType:webcam; detectionMode: mono_and_matrix; matrixCodeType: 3x3; '
    renderer="logarithmicDepthBuffer: true; precision: medium;">
    
    <?php if($scene->status == 1): ?>
      <a-assets>
        <?php $__currentLoopData = $entities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $assetType = $entity->props->asset->type; // img, video, audio, model
          ?>
          <?php switch($assetType):
            case ('img'): ?>
              <img id="asset-<?php echo e($entity->id); ?>" src="<?php echo e($entity->props->entity->src); ?>">
              <?php break; ?>
            <?php case ('video'): ?>
              <video id="asset-<?php echo e($entity->id); ?>" src="<?php echo e($entity->props->entity->src); ?>" class="media"></video>
              <?php break; ?>
            <?php case ('audio'): ?>
              <audio id="asset-<?php echo e($entity->id); ?>" src="<?php echo e($entity->props->entity->src); ?>" class="media"></audio>
              <?php break; ?>
            <?php case ('model'): ?>
              <a-asset-item id="asset-<?php echo e($entity->id); ?>" src="<?php echo e($entity->props->entity->src); ?>"></a-asset-item>
              <?php break; ?>
          <?php endswitch; ?>  
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </a-assets>
    <?php endif; ?>
    <a-marker type="barcode" value="<?php echo e($marker->props->marker_value); ?>" smooth="true" smoothCount="5" smoothTolerance="0.01" smoothThreshold="2">
      <?php
        $cf = 2 * (100/42); // Correction factor
        $attr = ''; // Entity attribute
      ?>
      
      
      <?php if($scene->status == 1): ?>
        <?php $__currentLoopData = $entities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $type = $entity->type; // a-image, a-video, a-sound, a-gltf-model 
            $props = $entity->props->entity;
            if($type == 'a-gltf-model') {
              $attr .= ' animation-mixer';
            }
            if($type == 'a-image' && $entity->props->asset->ext == 'gif') {
              $attr .= ' shader="gif"';
            }
          ?>
          <?php $__currentLoopData = $props; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prop => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php switch($prop):
                case ('position'): ?>
                <?php case ('rotation'): ?>
                <?php case ('scale'): ?>
                  <?php
                    $x = $v->x; 
                    $y = $v->y; 
                    $z = $v->z;
                    if($prop == 'position') {
                      $y += 1.5;            
                      $y -= 0.75; 
                    }
                    if($prop == 'position' || ($prop == 'scale' && $type == 'a-gltf-model')) {
                      $x *= $cf;
                      $y *= $cf;
                      $z *= $cf;
                    }
                    $attr .= " $prop=\"$x $y $z\"";
                  ?>
                  <?php break; ?>
                <?php case ('src'): ?>
                  <?php
                    $src = '#asset-' . $entity->id;
                    if($type == 'a-sound') {
                      $src = 'src: ' . $src;
                    } 
                    $attr .= " src=\"$src\"";   
                  ?>
                  <?php break; ?>
                <?php case ('width'): ?>
                <?php case ('height'): ?>
                  <?php
                    $v *= $cf;
                    $attr .= " $prop=\"$v\"";  
                  ?>  
                  <?php break; ?>
                <?php default: ?>
                  <?php
                    $attr .= " $prop=\"$v\"";
                  ?>
                  <?php break; ?>          
            <?php endswitch; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
          <?php
            $attr .= ' id="entity-obj-' .$entity->id. '"';
            echo "<$type $attr></$type>";   
            $attr = '';
          ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php else: ?>
        <?php
          $width = 3 * $cf;
          $height = 0.5 * $cf;
        ?>
        <a-text
          id="text-not-public" 
          visible="true"
          value="<?php echo e(__('This scene is not public.')); ?>" 
          width="<?php echo e($width); ?>"
          height="<?php echo e($height); ?>"
          align="center"
          geometry="primitive:plane; height: <?php echo e(0.5 * $cf); ?>; width: <?php echo e(1.5 * $cf); ?>;"
          material="color: blue;"
          position="0 0.25 0"
          rotation="-20 0 0">
        </a-text>
      <?php endif; ?>
    </a-marker>
    <a-entity camera></a-entity>
  </a-scene>

  
  <div class="ar-btn-play-container">
    <div class="mx-auto ar-btn-play-subcontainer">
      <button id="btn-play-pause" class="btn btn-outline-danger ar-btn-play" hidden>
        <i class="fas fa-play"></i> <i class="fas fa-pause"></i>
      </button>
    </div>
  </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.ar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Andre\laragon\www\Laracast\holograma\resources\views/ar/browser.blade.php ENDPATH**/ ?>