
<?php $__env->startSection('title', __('Settings')); ?>

<?php $__env->startSection('content'); ?>

<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">
        <i class="fas fa-fw fa-cog"></i> <?php echo e(__('Settings')); ?>

    </h1>
</div>

<?php if($errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

<?php if(session('status')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('status')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

<form action="<?php echo e(url('/configs')); ?>" method="POST" enctype="multipart/form-data" id="config-form">
    <?php echo csrf_field(); ?>

    <!-- THEME -->
    <div class="row">
        <div class="col col-md-12">

            <h2 class="h5"><?php echo e(__('Theme')); ?></h2>
            <hr>

            <div class="form-group row">
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Logo')); ?></label>
                <div class="col-sm-6 col-md-4">
                        <label class="col-form-label">
                            <img src="<?php echo e($LOGO_FILE); ?>" width="400" class="img-thumbnail" id="themelogo-preview">
                        </label>
                            
                    <div class="custom-file">
                        <input type="file" name="APP_LOGO_FILE" class="custom-file-input" id="themelogo" accept="image/png,image/gif,image/jpeg">
                        <label class="custom-file-label" for="themelogo" data-browse="<?php echo e(__('Browse')); ?>"><?php echo e(__('Choose file')); ?></label>
                        <small id="icon-help" class="form-text text-muted">
                            <?php echo e(__('Recommended width between 400px and 800px.')); ?>

                        </small> 
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Icon')); ?></label>
                <div class="col-sm-6 col-md-4">
                    <label class="col-form-label">
                        <img src="<?php echo e($ICON_FILE); ?>" width="40" class="img-thumbnail" id="themeicon-preview">
                    </label>
                    
                    <div class="custom-file">
                        <input type="file" name="APP_ICON_FILE" class="custom-file-input" id="themeicon" accept="image/png,image/gif,image/jpeg">
                        <label class="custom-file-label" for="themeicon" data-browse="<?php echo e(__('Browse')); ?>"><?php echo e(__('Choose file')); ?></label>
                        <small id="icon-help" class="form-text text-muted">
                            <?php echo e(__('Recommended size 40x40.')); ?>

                        </small> 
                    </div>
                </div>
            </div>
            
            <div class="form-group row">
                <label for="themecolor" class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Color')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <input type="text" name="APP_THEME_COLOR" value="<?php echo e($APP_THEME_COLOR); ?>" class="form-control" id="themecolor">
                    <input type="color" value="<?php echo e($APP_THEME_COLOR); ?>" class="form-control" id="themecolor2">           
                </div>
            </div>

        </div>
    </div>


    <!-- COMPONENT LOADING SCREEN (not implemented) -->
    <input type="hidden" name="APP_SCENE_COMPONENT_LOADING_SCREEN_ENABLED" value="0">
    <input type="checkbox" id="loading-screen" name="APP_SCENE_COMPONENT_LOADING_SCREEN_ENABLED" value="1" <?php echo e($APP_SCENE_COMPONENT_LOADING_SCREEN_ENABLED == '1'? 'checked': ''); ?> hidden>
    <input type="text" id="loader-title" name="APP_SCENE_COMPONENT_LOADING_SCREEN_TITLE" value="<?php echo e($APP_SCENE_COMPONENT_LOADING_SCREEN_TITLE); ?>" hidden>      
    <input type="color" id="loader-dotscolor" name="APP_SCENE_COMPONENT_LOADING_SCREEN_DOTSCOLOR" value="<?php echo e($APP_SCENE_COMPONENT_LOADING_SCREEN_DOTSCOLOR); ?>" hidden>      
    <input type="color" id="loader-backgroundcolor" name="APP_SCENE_COMPONENT_LOADING_SCREEN_BACKGROUNDCOLOR" value="<?php echo e($APP_SCENE_COMPONENT_LOADING_SCREEN_BACKGROUNDCOLOR); ?>" hidden>


    <!-- MARKER -->
    <input type="radio" id="qrcode" name="APP_MARKER_TYPE" value="qrcode" <?php echo e($APP_MARKER_TYPE == 'qrcode'? 'checked': ''); ?> hidden>
    <input type="radio" id="barcode" name="APP_MARKER_TYPE" value="barcode" <?php echo e($APP_MARKER_TYPE == 'barcode'? 'checked': ''); ?> hidden>
    <input type="number" id="marker-imagesize" name="APP_MARKER_IMAGESIZE" min="100" max="5000" step="1" value="<?php echo e($APP_MARKER_IMAGESIZE); ?>" hidden>
    <input type="radio" id="marker-matrix-3x3" name="APP_MARKER_MATRIX_TYPE" value="3x3" <?php echo e($APP_MARKER_MATRIX_TYPE == '3x3'? 'checked': ''); ?> hidden>
    <input type="radio" id="marker-matrix-4x4" name="APP_MARKER_MATRIX_TYPE" value="4x4" <?php echo e($APP_MARKER_MATRIX_TYPE == '4x4'? 'checked': ''); ?> hidden>


    <!-- QR CODE -->
    <div class="row">
        <div class="col col-md-12">

            <h2 class="h5"><?php echo e(__('QR Code')); ?></h2>
            <hr>

            <div class="form-group row">
                <div class="col-sm-6 offset-sm-3 col-md-4 offset-md-2"> 
                    <div class="form-check">
                        <input type="hidden" name="APP_QRCODE_CAPTION_ENABLED" value="0">
                        <input class="form-check-input" type="checkbox" name="APP_QRCODE_CAPTION_ENABLED" value="1" id="caption-enabled" <?php echo e($APP_QRCODE_CAPTION_ENABLED == '1'? 'checked': ''); ?>>
                        <label class="form-check-label" for="caption-enabled">
                            <?php echo e(__('Show caption on generated QR CODES.')); ?>

                        </label>
                    </div>
                </div>
            </div>
     
            <div class="form-group row qrcode" <?php echo e($APP_QRCODE_CAPTION_ENABLED != '1'? 'hidden': ''); ?>>
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Preview')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <label class="col-form-label">
                        <img src="<?php echo e(url('configs/preview/qrcode?caption='.rawurlencode($APP_QRCODE_CAPTION_TEXT).'&fontsize='.$APP_QRCODE_CAPTION_TEXT_FONTSIZE)); ?>" width="400" class="img-thumbnail" id="qrcode-preview">
                    </label>
                </div>
            </div>

            <div class="form-group row qrcode" <?php echo e($APP_QRCODE_CAPTION_ENABLED != '1'? 'hidden': ''); ?>>
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Caption text')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <input type="text" name="APP_QRCODE_CAPTION_TEXT" value="<?php echo e($APP_QRCODE_CAPTION_TEXT); ?>" id="caption-text" class="form-control" maxlength="50">          
                </div>
            </div>

            <div class="form-group row qrcode" <?php echo e($APP_QRCODE_CAPTION_ENABLED != '1'? 'hidden': ''); ?>>
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Font size')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <input type="number" name="APP_QRCODE_CAPTION_TEXT_FONTSIZE" value="<?php echo e($APP_QRCODE_CAPTION_TEXT_FONTSIZE); ?>" id="caption-font" class="form-control" min="10" max="500" step="1">          
                </div>
            </div>

            <div class="form-group row qrcode" <?php echo e($APP_QRCODE_CAPTION_ENABLED != '1'? 'hidden': ''); ?>>
                <div class="col-sm-6 offset-sm-3 col-md-4 offset-md-2"> 
                    <div class="form-check">
                        <input type="hidden" name="APP_QRCODE_CAPTION_EDITABLE" value="0">
                        <input class="form-check-input qrcode" type="checkbox" name="APP_QRCODE_CAPTION_EDITABLE" value="1" id="caption-editable" <?php echo e($APP_QRCODE_CAPTION_EDITABLE == '1'? 'checked': ''); ?>>
                        <label class="form-check-label" for="caption-editable">
                                <?php echo e(__('Editors can modify captions.')); ?>

                        </label>
                    </div>
                </div>
            </div>
                
        </div>
    </div>


    <!-- FILE UPLOAD -->
    <div class="row">
        <div class="col col-md-12">

            <h2 class="h5"><?php echo e(__('File Upload')); ?></h2>
            <hr>

            <div class="form-group row">
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Max upload file size (KB)')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <input type="number" name="APP_UPLOAD_MAX_FILESIZE" value="<?php echo e($APP_UPLOAD_MAX_FILESIZE); ?>" class="form-control" min="512" max="<?php echo e($upload_max_filesize); ?>" step="1">          
                    <small class="form-text text-muted">
                        <?php echo e(__('php.ini limit: ') . $upload_max_filesize); ?>KB
                    </small> 
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Max media width (px)')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <input type="number" name="APP_UPLOAD_MAX_MEDIA_WIDTH" value="<?php echo e($APP_UPLOAD_MAX_MEDIA_WIDTH); ?>" class="form-control" min="800" max="5000" step="1">          
                    <small class="form-text text-muted">
                        <?php echo e(__('Maximum width of images and videos.')); ?>

                    </small> 
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Max media height (px)')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <input type="number" name="APP_UPLOAD_MAX_MEDIA_HEIGHT" value="<?php echo e($APP_UPLOAD_MAX_MEDIA_HEIGHT); ?>" class="form-control" min="800" max="5000" step="1">          
                    <small class="form-text text-muted">
                        <?php echo e(__('Maximum height of images and videos.')); ?>

                    </small> 
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 col-md-2 col-form-label"><?php echo e(__('Max media duration')); ?></label>
                <div class="col-sm-6 col-md-4"> 
                    <input type="number" name="APP_UPLOAD_MAX_MEDIA_DURATION" value="<?php echo e($APP_UPLOAD_MAX_MEDIA_DURATION); ?>" class="form-control" min="10" max="600" step="1">          
                    <small class="form-text text-muted">
                        <?php echo e(__('Maximum time in seconds of sounds and videos.')); ?>

                    </small> 
                </div>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-sm-6 offset-sm-3 col-md-4 offset-md-2">
            <input type="submit" class="btn btn-primary my-4 ml-5 mx-auto" value="<?php echo e(__('Save Changes')); ?>" >
        </div>
    </div>

</form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kosbi728/ar.kosbit.com.br/laravel/resources/views/config/index.blade.php ENDPATH**/ ?>