
<?php $__env->startSection('title', __('My Scenes')); ?>

<?php $__env->startSection('content'); ?>

  <div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">
      <i class="fas fa-cubes"></i> <?php echo e(__('My Scenes')); ?>

    </h1>
  </div>

  <?php if(session('status')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('status')); ?>

      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
  <?php endif; ?>

  <?php 
  $status = [
    ['warning',  __('Draft')], 
    ['success', __('Published')], 
    ['secondary', __('Archived')]
  ]; 
  ?>

  <div class="row mb-3">
    <div class="col">
      <a href="<?php echo e(url('/scene/create')); ?>" class="btn holograma-btn"><i class="fas fa-cube"></i> <?php echo e(__('Create Scene')); ?></a>
    </div>
  </div>

  <div class="table-responsive">
      <table class="table table-bordered table-hover">
        <caption><?php echo e(__('Page :page of :pages. Total of :total scenes.', ['page' => $scenes->currentPage(), 'pages' => $scenes->lastPage(), 'total' => $scenes->total()])); ?></caption>
        <thead class="thead-light">
          <tr>
            <th scope="col">#ID</th>
            <th scope="col" class="title-column"><?php echo e(__('Title')); ?></th>
            <th scope="col"><?php echo e(__('Description')); ?></th>
            <th scope="col"><?php echo e(__('Status')); ?></th>
            <th scope="col"><?php echo e(__('Editable')); ?></th>
            <th scope="col"><?php echo e(__('Created')); ?></th>
            <th scope="col"><?php echo e(__('Published')); ?></th>
            <th scope="col" class="action-column"><?php echo e(__('Action')); ?></th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $scenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $scene): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <th scope="row"><?php echo e($scene->id); ?></th>
              <td><?php echo e($scene->title); ?></td>
              <td><?php echo e(strlen($scene->description) > 300? substr($scene->description, 0, 300) . ' ...': $scene->description); ?></td>
              <td><span class="badge badge-<?php echo e($status[$scene->status][0]); ?>"><?php echo e($status[$scene->status][1]); ?></span></td>
              <td><?php echo e($scene->editable? __('Yes'): __('No')); ?></td>
              <td><?php echo e(substr($scene->created_at, 0, 10)); ?></td>
              <td><?php echo e($scene->published_at? substr($scene->published_at, 0, 10): __('No')); ?></td>
              <td>
                <ul class="list-inline">
                  <li class="list-inline-item">
                    <a href="<?php echo e(url('/scenes/edit', ['scene' => $scene->id])); ?>" class="btn btn-link text-primary btn-sm">
                      <i class="fas fa-pencil-alt"></i>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <form 
                      id="form-delete-scene"
                      method="POST" 
                      action="<?php echo e(url('/scenes', ['scene' =>  $scene->id ])); ?>" 
                      data-message="<?php echo e(__('Do you want to delete the scene?')); ?>">
                      <?php echo csrf_field(); ?>
                      <?php echo method_field('DELETE'); ?>
                      <button type="submit" class="btn btn-link text-danger btn-sm"><i class="far fa-trash-alt"></i></button>
                    </form>
                  </li>
                </ul>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

  <?php echo e($scenes->onEachSide(5)->links()); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kosbi728/ar.kosbit.com.br/laravel/resources/views/scene/index.blade.php ENDPATH**/ ?>