@extends('layouts.ar')
@section('title', __('Augmented Reality'))

@section('content')
  @php
    $cameraParametersUrl = asset('storage/camera/camera_para.dat');
  @endphp
   
  <a-scene 
    vr-mode-ui="enabled: false"
    embedded 
    arjs='debugUIEnabled:false; sourceType:webcam; detectionMode: mono_and_matrix; matrixCodeType: 3x3; cameraParametersUrl: {{$cameraParametersUrl}};'
    renderer="logarithmicDepthBuffer: true; precision: medium;">
    {{-- scene is public (not draft or archived) --}}
    @if ($scene->status == 1)
      <a-assets>
        @foreach ($entities as $entity)
          @php
            $assetType = $entity->props->asset->type; // img, video, audio, model
          @endphp
          @switch($assetType)
            @case('img')
              <img id="asset-{{ $entity->id }}" src="{{ $entity->props->entity->src }}">
              @break
            @case('video')
              <video id="asset-{{ $entity->id }}" src="{{ $entity->props->entity->src }}" class="media"></video>
              @break
            @case('audio')
              <audio id="asset-{{ $entity->id }}" src="{{ $entity->props->entity->src }}" class="media"></audio>
              @break
            @case('model')
              <a-asset-item id="asset-{{ $entity->id }}" src="{{ $entity->props->entity->src }}"></a-asset-item>
              @break
          @endswitch  
        @endforeach
      </a-assets>
    @endif
    <a-marker type="barcode" value="{{ $marker->props->marker_value }}" smooth="true" smoothCount="10" smoothTolerance="0.01" smoothThreshold="1">
      @php
        $cf = 2 * (100/42); // Correction factor
        $attr = ''; // Entity attribute
      @endphp
      
      {{-- scene is public (not draft or archived) --}}
      @if ($scene->status == 1)
        @foreach ($entities as $entity)
          @php
            $type = $entity->type; // a-image, a-video, a-sound, a-gltf-model 
            $props = $entity->props->entity;
            if($type == 'a-gltf-model') {
              $attr .= ' animation-mixer';
            }
            if($type == 'a-image' && $entity->props->asset->ext == 'gif') {
              $attr .= ' shader="gif"';
            }
          @endphp
          @foreach ($props as $prop => $v)
            @switch($prop)
                @case('position')
                @case('rotation')
                @case('scale')
                  @php
                    $x = $v->x; 
                    $y = $v->y; 
                    $z = $v->z;
                    if($prop == 'position') {
                      $y += 1.5;            
                      $y -= 0.75; 
                    }
                    if($prop == 'position' || ($prop == 'scale' && $type == 'a-gltf-model')) {
                      $x *= $cf;
                      $y *= $cf;
                      $z *= $cf;
                    }
                    $attr .= " $prop=\"$x $y $z\"";
                  @endphp
                  @break
                @case('src')
                  @php
                    $src = '#asset-' . $entity->id;
                    if($type == 'a-sound') {
                      $src = 'src: ' . $src;
                    } 
                    $attr .= " src=\"$src\"";   
                  @endphp
                  @break
                @case('width')
                @case('height')
                  @php
                    $v *= $cf;
                    $attr .= " $prop=\"$v\"";  
                  @endphp  
                  @break
                @default
                  @php
                    $attr .= " $prop=\"$v\"";
                  @endphp
                  @break          
            @endswitch
          @endforeach 
          @php
            $attr .= ' id="entity-obj-' .$entity->id. '"';
            echo "<$type $attr></$type>";   
            $attr = '';
          @endphp
        @endforeach
      @else
        @php
          $width = 3 * $cf;
          $height = 0.5 * $cf;
        @endphp
        <a-text
          id="text-not-public" 
          visible="true"
          value="{{ __('This scene is not public.') }}" 
          width="{{ $width }}"
          height="{{ $height }}"
          align="center"
          geometry="primitive:plane; height: {{0.5 * $cf}}; width: {{1.5 * $cf}};"
          material="color: blue;"
          position="0 0.25 0"
          rotation="-20 0 0">
        </a-text>
      @endif
    </a-marker>
    <a-entity camera></a-entity>
  </a-scene>

  {{-- Button --}}
  <div class="ar-btn-play-container">
    <div class="mx-auto ar-btn-play-subcontainer">
      <button id="btn-play-pause" class="btn btn-outline-danger ar-btn-play" hidden>
        <i class="fas fa-play"></i> <i class="fas fa-pause"></i>
      </button>
    </div>
  </div>

@endsection