<?php

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        DB::table('users')->insert([
            [
                'name' => 'Admin',
                'email' => 'admin@admin.com',
                'password' => bcrypt('123456'),
                'role' => 0,
                'status' => 1,
                'email_verified_at' => date("Y-m-d H:i:s"),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s")
            ],
            [
                'name' => 'Editor',
                'email' => 'editor@editor.com',
                'password' => bcrypt('123456'),
                'role' => 1,
                'status' => 1,
                'email_verified_at' => date("Y-m-d H:i:s"),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s")
            ]
        ]);

        DB::table('configs')->insert([
            ['key' => 'APP_THEME_COLOR', 'value' => ''],
            ['key' => 'APP_MARKER_TYPE', 'value' => 'qrcode'],
            ['key' => 'APP_MARKER_IMAGESIZE', 'value' => '1024'],
            ['key' => 'APP_MARKER_MATRIX_TYPE', 'value' => '3x3'],
            ['key' => 'APP_QRCODE_CAPTION_ENABLED', 'value' => '1'],
            ['key' => 'APP_QRCODE_CAPTION_TEXT', 'value' => ''],
            ['key' => 'APP_QRCODE_CAPTION_TEXT_FONTSIZE', 'value' => '102'],
            ['key' => 'APP_UPLOAD_MAX_FILESIZE', 'value' => '4096'],
            ['key' => 'APP_UPLOAD_MAX_MEDIA_WIDTH', 'value' => '1920'],
            ['key' => 'APP_UPLOAD_MAX_MEDIA_HEIGHT', 'value' => '1920'],
            ['key' => 'APP_UPLOAD_MAX_MEDIA_DURATION', 'value' => '300'],
            ['key' => 'APP_SCENE_COMPONENT_LOADING_SCREEN_ENABLED', 'value' => '1'],
            ['key' => 'APP_SCENE_COMPONENT_LOADING_SCREEN_TITLE', 'value' => 'Loading...'],
            ['key' => 'APP_SCENE_COMPONENT_LOADING_SCREEN_DOTSCOLOR', 'value' => '#FFFFFF'],
            ['key' => 'APP_SCENE_COMPONENT_LOADING_SCREEN_BACKGROUNDCOLOR', 'value' => '#000000'],
            ['key' => 'APP_ICON_FILE', 'value' => ''],
            ['key' => 'APP_LOGO_FILE', 'value' => ''],
            ['key' => 'APP_QRCODE_CAPTION_EDITABLE', 'value' => '1']
        ]);
    }
}
