<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMarkersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::enableForeignKeyConstraints();
        
        Schema::create('markers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('type', 50)->comment('pattern, barcode, qrcode');
            $table->text('props')->comment('{"pattern_file":"filename.patt", "matrix_value": 8, "matrix_type":"3x3"}'); // 3x3 | 4x4 (matrixCodeType)
            $table->string('file', 15)->comment('filename.png');
            $table->integer('scene_id', false, true);
            
            //indexes
            $table->index('scene_id');

            //foreign key
            $table->foreign('scene_id')
                  ->references('id')
                  ->on('scenes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('markers');
    }
}
