<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEntitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('entities', function (Blueprint $table) {

            $table->increments('id');
            $table->string('name', 50)->nullable();
            $table->string('type', 50)->nullable()->comment('a-image, a-sound, a-video, a-gltf-model');
            $table->text('props')->nullable();
            $table->integer('scene_id', false, true);
            
            //indexes
            $table->index('scene_id');

            //foreign key
            $table->foreign('scene_id')
                  ->references('id')
                  ->on('scenes');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('entities');
    }
}
