<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScenesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('scenes', function (Blueprint $table) {

            $table->increments('id');
            $table->char('code', 10)->nullable();
            $table->string('title', 150)->nullable();
            $table->text('description')->nullable();
            $table->boolean('preload_assets')->default(0)->comment('Enable assets preloading');
            $table->boolean('status')->default(0)->comment('0 - draft, 1 - published, 2 - archived');
            $table->boolean('editable')->default(1)->comment('0 - no, 1 - yes; if not editable only admin can edit.');
            $table->timestamp('published_at')->nullable();
            $table->timestamps();
            $table->integer('user_id', false, true);

            //indexes
            $table->unique('code');
            $table->index('title');
            $table->index('status');
            $table->index('published_at');
            $table->index('created_at');
            $table->index('user_id');

            //foreign key
            $table->foreign('user_id')
                  ->references('id')
                  ->on('users');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scenes');
    }
}
