<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Scene extends Model
{

    /*
    |--------------------------------------------------------------------------
    | Attributes
    |--------------------------------------------------------------------------
    |
    | - id
    | - code
    | - title
    | - description
    | - preload_assets
    | - status
    | - editable
    | - published_at
    | - created_at
    | - updated_at
    | - user_id
    |
    */


     /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [];


    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'published_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];



    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */


    /**
     * Get the user of scene
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the entities of scene
     */
    public function entities()
    {
        return $this->hasMany('App\Entity');
    }

    /**
     * Get the marker of scene
     */
    public function marker()
    {
        return $this->hasOne('App\Marker');
    }
}
