<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Artisan;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (empty(env('APP_KEY'))) {
            Artisan::call('key:generate');
            Artisan::call('storage:link');
        }   
    
        //Artisan::call('cache:clear');
        
        $icon = Cache::get('APP_ICON_FILE');
        $icon = empty($icon)? 'icon-holograma.png': $icon;
        View::share('ICON_FILE', url('storage/' . $icon));

        $logo = Cache::get('APP_LOGO_FILE');
        $logo = empty($logo)? 'logo-holograma.png': $logo;
        View::share('LOGO_FILE', url('storage/' . $logo));

        $theme_color = Cache::get('APP_THEME_COLOR', '#4e73df');
        $theme_color = empty($theme_color)? '#4e73df': $theme_color;
        View::share('THEME_COLOR', $theme_color);
        
        \URL::forceScheme('https');

    }
}
