<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddEditMarkerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $validation = [
            'scene_code' => 'required|exists:scenes,code',
            'scene_id' => 'required|exists:scenes,id',
            'marker_type' => 'sometimes|string|in:qrcode,barcode',                             
            'matrix_type' => 'sometimes|string|in:3x3,4x4',                            
            'marker_size' => 'sometimes|numeric|min:100|max:3840',               
            'qrcode_caption' => 'sometimes|nullable|string|max:100',  
            'qrcode_fontsize' => 'sometimes|numeric|min:1|max:1000', 
        ];
        return $validation;
    }
}
