<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Scene;

class ArController extends Controller
{
    
    public function browser($code)
    {
        $scene = Scene::with('entities', 'marker')
                        ->where('code', $code)
                        ->first();
        // Marker
        $scene->marker = $scene->marker?? "";
        if(!empty($scene->marker)) {
            $scene->marker->props = json_decode($scene->marker->props);
        }
        // Entities
        $scene->entities = ($scene->entities)->map(function($entity) {
            $entity->props = json_decode($entity->props);
            return $entity;
        }); 

        return view('ar.browser', [
            'scene' => $scene, 
            'entities' => $scene->entities, 
            'marker' => $scene->marker
        ]);
    }

}
