<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Entity extends Model
{

    /*
    |--------------------------------------------------------------------------
    | Attributes
    |--------------------------------------------------------------------------
    |
    
    | - a-image
    | - a-sound
    | - a-video
    | - a-text
    | - a-gltf-model 
    |
    */

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['scene_id'];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * Get the scene of entity
     */
    public function scene()
    {
        return $this->belongsTo('App\Scene');
    }

}
