<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Config extends Model
{
    
    /*
    |--------------------------------------------------------------------------
    | Attributes
    |--------------------------------------------------------------------------
    |
    | - id
    | - key
    | - value
    |
    */

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */

    public $timestamps = false;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['value'];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * Scope a query to get and set configs.
     *
     * @param  \Illuminate\Database\Eloquent\Builder $query
     * @param  string  $key
     * @return int|string
     */
    public function scopeOpt($query, $key, $value=null)
    {
        if (is_null($value)) {
            return Cache::get($key, $query->where('key', $key)->first()->value);
        }
        $opt = $query->where('key', $key)->first();
        $opt->value = $value;
        $opt->save();
        Cache::put($key, $value);
        return $opt;
    }
    
}
